<?php

/**
 * Note : Code is released under the GNU LGPL
 *
 * Please do not change the header of this file
 *
 * This library is free software; you can redistribute it and/or modify it under the terms of the GNU
 * Lesser General Public License as published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See the GNU Lesser General Public License for more details.
 */
/**
 * File:        Piece.php
 * Project:     DHL API
 *
 * @author      Al-Fallouji Bashar
 * @version     0.1
 */
namespace DhlVendor\DHL\Datatype\AP;

use DhlVendor\DHL\Datatype\Base;
/**
 * Piece Request model for DHL API
 */
class Piece extends Base
{
    /**
     * Is this object a subobject
     * @var boolean
     */
    protected $_isSubobject = \true;
    /**
     * Parameters of the datatype
     * @var array
     */
    protected $_params = array('PieceID' => array('type' => 'PieceID', 'required' => \false, 'subobject' => \false, 'comment' => 'Piece ID', 'maxLength' => '35'), 'PackageType' => array('type' => 'PackageType', 'required' => \false, 'subobject' => \false, 'comment' => 'Package Type (EE: DHL Express Envelope, OD:Other DHL Packaging, CP:Customer-provided.Ground shipments must choose CP)', 'length' => '2', 'enumeration' => 'EE,OD,CP'), 'Weight' => array('type' => 'Weight', 'required' => \false, 'subobject' => \false, 'comment' => 'Weight of piece or shipment', 'fractionDigits' => '1', 'maxInclusive' => '999999.9', 'totalDigits' => '7'), 'DimWeight' => array('type' => 'Weight', 'required' => \false, 'subobject' => \false, 'comment' => 'Weight of piece or shipment', 'fractionDigits' => '1', 'maxInclusive' => '999999.9', 'totalDigits' => '7'), 'Width' => array('type' => 'positiveInteger', 'required' => \false, 'subobject' => \false), 'Height' => array('type' => 'positiveInteger', 'required' => \false, 'subobject' => \false), 'Depth' => array('type' => 'positiveInteger', 'required' => \false, 'subobject' => \false), 'PieceContents' => array('type' => 'string', 'required' => \false, 'subobject' => \false));
}
