<?php

/**
 * Note : Code is released under the GNU LGPL
 *
 * Please do not change the header of this file
 *
 * This library is free software; you can redistribute it and/or modify it under the terms of the GNU
 * Lesser General Public License as published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See the GNU Lesser General Public License for more details.
 */
/**
 * File:        WeightSeg.php
 * Project:     DHL API
 *
 * @author      Al-Fallouji Bashar
 * @version     0.1
 */
namespace DhlVendor\DHL\Datatype\AM;

use DhlVendor\DHL\Datatype\Base;
/**
 * WeightSeg Request model for DHL API
 */
class WeightSeg extends Base
{
    /**
     * Is this object a subobject
     * @var boolean
     */
    protected $_isSubobject = \true;
    /**
     * Parameters of the datatype
     * @var array
     */
    protected $_params = array('Weight' => array('type' => 'Weight', 'required' => \false, 'subobject' => \false, 'comment' => 'Weight of piece or shipment', 'fractionDigits' => '1', 'maxInclusive' => '999999.9', 'totalDigits' => '7'), 'WeightUnit' => array('type' => 'WeightUnit', 'required' => \false, 'subobject' => \false, 'comment' => 'Unit of weight measurement (L:Pounds)', 'length' => '1', 'enumeration' => 'K,L'));
}
