<?php 
// Featured Image by URL metabox Template

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) exit;
$image_url = '';
$image_alt = '';
if( isset( $image_meta['img_url'] ) && $image_meta['img_url'] != '' ){
	$image_url = esc_url( $image_meta['img_url'] );
}
if( isset( $image_meta['img_alt'] ) && $image_meta['img_alt'] != '' ){
	$image_alt = esc_attr( $image_meta['img_alt'] );
}
?>

<div id="ei_metabox_content" >

	<input id="ei_url" type="text" name="ei_url" placeholder="<?php _e('Image URL', 'external-images') ?>" value="<?php echo $image_url; ?>" />
	<a id="ei_preview" class="button" >
		<?php _e('Preview', 'external-images') ?>
	</a>
	
	<input id="ei_alt" type="text" name="ei_alt" placeholder="<?php _e('Alt text (Optional)', 'external-images') ?>" value="<?php echo $image_alt; ?>" />

	<div >
		<span id="ei_noimg"><?php _e('No image', 'external-images'); ?></span>
			<img id="ei_img" src="<?php echo $image_url; ?>" />
	</div>

	<a id="ei_remove" class="button" style="margin-top:4px;"><?php _e('Remove Image', 'external-images') ?></a>
</div>

<script>
	jQuery(document).ready(function($){

		<?php if ( ! $image_meta['img_url'] ): ?>
			$('#ei_img').hide().attr('src','');
			$('#ei_noimg').show();
			$('#ei_alt').hide().val('');
			$('#ei_remove').hide();
			$('#ei_url').show().val('');
			$('#ei_preview').show();
		<?php else: ?>
			$('#ei_noimg').hide();
			$('#ei_remove').show();
			$('#ei_url').hide();
			$('#ei_preview').hide();
		<?php endif; ?>

		// Preview Featured Image
		$('#ei_preview').click(function(e){
			
			e.preventDefault();
			imgUrl = $('#ei_url').val();
			
			if ( imgUrl != '' ){
				$("<img>", {
						    src: imgUrl,
						    error: function() {alert('<?php _e('Error URL Image', 'external-images') ?>')},
						    load: function() {
						    	$('#ei_img').show().attr('src',imgUrl);
						    	$('#ei_noimg').hide();
						    	$('#ei_alt').show();
						    	$('#ei_remove').show();
						    	$('#ei_url').hide();
						    	$('#ei_preview').hide();
						    }
				});
			}
		});

		// Remove Featured Image
		$('#ei_remove').click(function(e){

			e.preventDefault();
			$('#ei_img').hide().attr('src','');
			$('#ei_noimg').show();
	    	$('#ei_alt').hide().val('');
	    	$('#ei_remove').hide();
	    	$('#ei_url').show().val('');
	    	$('#ei_preview').show();

		});

	});

</script>