<?php
/**
 * Plugin Name:       External Images
 * Plugin URI: http://www.wpintense.com
 * Description: Allows WordPress to use external image URLs instead of downloading featured images to your website.  Prevents Datafeedr from importing images to your site, allowing you to just use the external image URL on the affiliate CDN. Also compatible with WP All Import - simply import your image(s) to a custom meta field called external_image_url and don't import images the normal way with WP All Import and your site will use these external images. Also adds an external image editor field to your product/post editor below your featured image area. <h2>Updates</h2><ul><li>Works with cloudflare based SSL now too</li><li>Also spots Datafeedr comparison sets (which already use external images) and proxies THOSE images through SSL</li></ul>
 * Version: 2.52
 * Author: Dave Hilditch
 * Author URI: http://www.wpintense.com
 * License:           GPL-2.0+
 * License URI:       http://www.gnu.org/licenses/gpl-2.0.txt
 * Text Domain:       external-images
 * Domain Path:       /languages
 *
 * @package     External_Images
 * @author      Dave Hilditch <support@wpintense.com>
 * 
 * This plugin has been in development since 2015. In June 2020, we merged our code with some of the code from an open source plugin called Featured Image By URL: https://github.com/Knawat/featured-image-by-url.
 * This merge mostly improved our code structure, but also gave a new benefit of working better with more themes and allowing theme features like magnifying glass etc to continue working.
 * Our plugin continues to have more features - product variation galleries, SEO support, more speed, datafeedr integration, CSS image resizing, custom post type support, SSL proxying of http images onto your https domain and many more.
 */

// If this file is called directly, abort.
if ( ! defined( 'ABSPATH' ) ) exit;

if( ! class_exists( 'External_Images' ) ): 

global $ei_db_version;
$ei_db_version = 2.46;
require 'plugin-updates/plugin-update-checker.php'; 
$ExternalImagesWidgetsUpdateChecker = PucFactory::buildUpdateChecker(
	'http://www.wpintense.com/assets/plugins/external-images.json',
	__FILE__,
	'external-images'
); 
require_once(plugin_dir_path(__FILE__) . 'wpintense-settings.php');

add_action( 'wp_enqueue_scripts', 'external_images_scripts');
function external_images_scripts() {
	wp_enqueue_style( 'external-images-style', plugins_url('assets/css/external-images.css', __FILE__) , null, '2.39');
	wp_enqueue_script( 'external-images-script', plugins_url('assets/js/external-images.js', __FILE__), array('jquery'), '2.39');
	$localize = array(
		'ajaxurl' => admin_url('admin-ajax.php'),
		'nonce' => wp_create_nonce('_check__ajax_ei')
	);
	wp_localize_script( 'external-images-script', 'ajax_params', $localize);
}



/**
* Main External Images class
*/
class External_Images{
	
	/** Singleton *************************************************************/
	/**
	 * External_Images The one true External_Images.
	 */
	private static $instance;

    /**
     * Main External Images Instance.
     * 
     * Ensure that only one instance of External_Images exists in memory at any one time.
     * Also prevents needing to define globals all over the place.
     *
     * @since 1.0.0
     * @static object $instance
     * @uses External_Images::setup_constants() Setup the constants needed.
     * @uses External_Images::includes() Include the required files.
     * @uses External_Images::laod_textdomain() load the language files.
     * @see run_ei()
     * @return object| External Images the one true External Images.
     */
	public static function instance() {
		if( ! isset( self::$instance ) && ! (self::$instance instanceof External_Images ) ) {
			self::$instance = new External_Images;
			self::$instance->setup_constants();

			add_action( 'plugins_loaded', array( self::$instance, 'load_textdomain' ) );

			self::$instance->includes();
			self::$instance->admin  = new External_Images_Admin();
			self::$instance->common = new External_Images_Common();

		}
		return self::$instance;	
	}

	/** Magic Methods *********************************************************/

	/**
	 * A dummy constructor to prevent External_Images from being loaded more than once.
	 *
	 * @since 1.0.0
	 * @see External_Images::instance()
	 * @see run_ei()
	 */
	private function __construct() { /* Do nothing here */ }

	/**
	 * A dummy magic method to prevent External_Images from being cloned.
	 *
	 * @since 1.0.0
	 */
	public function __clone() { _doing_it_wrong( __FUNCTION__, __( 'Cheatin&#8217; huh?', 'external-images' ), '1.1.4' ); }

	/**
	 * A dummy magic method to prevent External_Images from being unserialized.
	 *
	 * @since 1.0.0
	 */
	public function __wakeup() { _doing_it_wrong( __FUNCTION__, __( 'Cheatin&#8217; huh?', 'external-images' ), '1.1.4' ); }


	/**
	 * Setup plugins constants.
	 *
	 * @access private
	 * @since 1.0.0
	 * @return void
	 */
	private function setup_constants() {

		// Plugin version.
		if( ! defined( 'ei_VERSION' ) ){
			define( 'ei_VERSION', '1.1.4' );
		}

		// Plugin folder Path.
		if( ! defined( 'ei_PLUGIN_DIR' ) ){
			define( 'ei_PLUGIN_DIR', plugin_dir_path( __FILE__ ) );
		}

		// Plugin folder URL.
		if( ! defined( 'ei_PLUGIN_URL' ) ){
			define( 'ei_PLUGIN_URL', plugin_dir_url( __FILE__ ) );
		}

		// Plugin root file.
		if( ! defined( 'ei_PLUGIN_FILE' ) ){
			define( 'ei_PLUGIN_FILE', __FILE__ );
		}

		// Options
		if( ! defined( 'ei_OPTIONS' ) ){
			define( 'ei_OPTIONS', 'ei_settings' );
		}

		// gallary meta key
		if( ! defined( 'ei_wcgallery' ) ){
			define( 'ei_wcgallery', '_ei_wcgallery' );
		}

	}

	/**
	 * Include required files.
	 *
	 * @access private
	 * @since 1.0.0
	 * @return void
	 */
	private function includes() {
		require_once ei_PLUGIN_DIR . 'includes/class-external-images-admin.php';
		require_once ei_PLUGIN_DIR . 'includes/class-external-images-common.php';
	}

	
	/**
	 * Loads the plugin language files.
	 * 
	 * @access public
	 * @since 1.0.0
	 * @return void
	 */
	public function load_textdomain(){

		load_plugin_textdomain(
			'external-images',
			false,
			basename( dirname( __FILE__ ) ) . '/languages'
		);
	
	}
	
}

endif; // End If class exists check.

/**
 * The main function for that returns External_Images
 *
 * The main function responsible for returning the one true External_Images
 * Instance to functions everywhere.
 *
 * Use this function like you would a global variable, except without needing
 * to declare the global.
 *
 * Example: <?php $ei = run_ei(); ?>
 *
 * @since 1.0.0
 * @return object|External_Images The one true External_Images Instance.
 */
function run_ei() {
	return External_Images::instance();
}

// Get External_Images Running.
$GLOBALS['ei'] = run_ei();


/**
 * Kept for backwards compatibility
 * @since 1.0.0
 * @return null
 */
function ei_display_gallery() {
}

function ei_getimagesize($imageurl) {
	return array(600, 600);
//	return @getimagesize($imageurl);
}
add_filter('puc_manual_check_message-' . $ExternalImagesWidgetsUpdateChecker->slug, function($message) {
	global $ExternalImagesWidgetsUpdateChecker;
	$licensemessage = wpi_check_license($ExternalImagesWidgetsUpdateChecker->slug);
	if ($licensemessage['error'] = 'valid') {
		return $message;
	}
	return $licensemessage;
}, 10);
add_filter('puc_request_info_result-' . $ExternalImagesWidgetsUpdateChecker->slug, function($pluginInfo, $wpiresponse) {
	global $ExternalImagesWidgetsUpdateChecker;
	$licensemessage = wpi_check_license($ExternalImagesWidgetsUpdateChecker->slug);
	if ($licensemessage['error'] != 'valid') {
		$pluginInfo->version = 1.0; // setting version to 1.0 means the update checker thinks there is no update available
	}
	return $pluginInfo;
}, 10, 2);
//todo: if WPI license settins don't exist, create settings page
//todo: add link on plugin links to WPI settings page
add_filter('plugin_row_meta', function($pluginMeta, $pluginFile) {
	global $ExternalImagesWidgetsUpdateChecker;

	$isRelevant = ($pluginFile == $ExternalImagesWidgetsUpdateChecker->pluginFile)
	|| (!empty($ExternalImagesWidgetsUpdateChecker->muPluginFile) && $pluginFile == $ExternalImagesWidgetsUpdateChecker->muPluginFile);
	if ( $isRelevant && current_user_can('update_plugins') ) {
		$linkUrl = get_admin_url(null, 'admin.php?page=wpintense');
		$linkText = 'License key';
		$pluginMeta[] = sprintf('<a href="%s">%s</a>', esc_attr($linkUrl), $linkText);

		$pluginMeta[] = sprintf('<a href="%s">%s</a>', esc_attr(get_admin_url(null, 'admin.php?page=ei')), "Settings");
	}
	return $pluginMeta;
}, 20, 2);
